﻿var errorLogs = {
    context: $(".v-errorLogs"),
    webspaceId: null,
    datatable: null,
    initializeDataTable: function (folder) {
        this.datatable = $(".h-errorLogsTable", this.context).a4datatable({
            advancedFilter: false,
            ajaxAction: a4.getAction("GetWebSpaceErrorLogs", "MultiMode", "Settings", { webspaceId: errorLogs.webspaceId }),
            columns: [
                { "Title": resources.ServerName, "Data": "ServerName" },
                { "Title": resources.ModuleName, "Data": "ProjectName" },
                { "Title": resources.ErrorCode, "Data": "ErrorCode", "Type": "numeric" },
                { "Title": resources.ErrorLabel, "Data": "ErrorLabel" },
                { "Title": resources.Date, "Data": "DateTime", "Type": "date" },
                { "Title": resources.Description, "Data": "Description" }
            ],
            stateKey: "ErrorLogs",
            quickFilter: {
                "Items": [
                    { "Label": resources.Today, "AjaxParams": { "period": "today" } },
                    { "Label": resources.ThisWeek, "AjaxParams": { "period": "week" } },
                    { "Label": resources.ThisMonth, "AjaxParams": { "period": "month" } },
                    { "Label": resources.Custom, "AjaxParams": { "period": "custom" }, "CustomInputs": [{ "Label": resources.From, "Type": "date", "Key": "period_from" }, { "Label": resources.To, "Type": "date", "Key": "period_to" }] }
                ]
            }
        });
    }
}

$(document).ready(function () {
    if (errorLogs.context.length > 0) {
        errorLogs.webspaceId = $("#WebSpaceId", errorLogs.context).val();
        errorLogs.initializeDataTable();
    }
});